function [hdata,bend,binidx] = myhist(data,bins,blim)
%my take on the histogram, which should be used if you want to bin a
%dataset and then used the same binning to create averaged data points for
%adjoining datasets.
%Synatax:   [hdata,bctr,binidx] = myhist(data,bins,[0 100]);
%Input:     bins = the number of bins in the histogram.
%           data = the array to be binned
%           blim = define the bin max and bin mix, if left out, the
%               bin limits are self defined by the data
%Output:    hdata = numbers per bins.
%           bend = left bin end
%           binidx = the indexs of the data points within each bin

if nargin<3;
    blim = [];  %default empty
end

data(isnan(data(:,1)),:) = [];  %make sure the data is cleaned of NaNs

%the bahavior is that is data is a vector then it's just a straight forward
%histogram, just use hist, but if the data is more than one column, then
%the first column will be used to make the histogram, and the other columns
%we will generate statistics per bin.
if isempty(blim)    %user not defined, generate limits
    bend = linspace(min(data(:,1)),max(data(:,1)),bins+1);       
else    %use the limits
    bend = linspace(blim(2),blim(1),bins+1);
end

%now bin according to the bends
for i = 1:bins
    if i~=bins  %not he last bin
        binidx{i} = find(data(:,1)>=bend(i)&data(:,1)<bend(i+1));    %fill the bin
    else    %the last bin
        binidx{i} = find(data(:,1)>=bend(i)&data(:,1)<=bend(i+1));    %fill the bin
    end
    hdata{1}(i) = size(binidx{i},1);
end

%histogram done, now process other data if needed and tack onto hdata
if size(data,2)~=1
    for j = 2:size(data,2)
        for k = 1:bins
            tmp = data(binidx{k},j);    %grap the data points
            hdata{j}(1,k) = mean(tmp);     %put the averge data way
            hdata{j}(2,k) = std(tmp);     %put the standard deviation data way
            hdata{j}(3,k) = std(tmp)/sqrt(size(binidx{k},1));     %calculate the standard error data way
        end
    end
end